<?php
/**
 * Mu Roulette
 * https://webenginecms.org/
 * 
 * @version 1.1.0
 * @author Lautaro Angelico <http://lautaroangelico.com/>
 * @copyright (c) 2013-2020 Lautaro Angelico, All Rights Reserved
 * @build w3c8c718b75a0f1fa1a557f7f9d70877
 */

$rewardTypeList = array(
	'wcoin',
	'wcoinc',
	'wcoinp',
	'goblinpoints',
	'ruud',
	'zen',
	'resets',
	'freespin'
);

function saveChanges($rewardTypeList) {
	global $_POST;

	$xmlPath = __PATH_ROULETTE_ROOT__.'config.xml';
	$xml = simplexml_load_file($xmlPath);

	if(!is_writable($xmlPath)) throw new Exception('The configuration file is not writable.');
	
	// ticket
	
	if(!Validator::UnsignedNumber($_POST['setting_1'])) throw new Exception('Submitted setting is not valid (spin_ticket_cost)');
	$xml->spin_ticket_cost = $_POST['setting_1'];
	
	if(!Validator::UnsignedNumber($_POST['setting_2'])) throw new Exception('Submitted setting is not valid (spin_ticket_configid)');
	$xml->spin_ticket_configid = $_POST['setting_2'];
	
	// credits
	
	if(!Validator::UnsignedNumber($_POST['setting_3'])) throw new Exception('Submitted setting is not valid (wcoin_config_id)');
	$xml->wcoin_config_id = $_POST['setting_3'];
	
	if(!Validator::UnsignedNumber($_POST['setting_4'])) throw new Exception('Submitted setting is not valid (wcoinc_config_id)');
	$xml->wcoinc_config_id = $_POST['setting_4'];
	
	if(!Validator::UnsignedNumber($_POST['setting_5'])) throw new Exception('Submitted setting is not valid (wcoinp_config_id)');
	$xml->wcoinp_config_id = $_POST['setting_5'];
	
	if(!Validator::UnsignedNumber($_POST['setting_6'])) throw new Exception('Submitted setting is not valid (goblinpoint_config_id)');
	$xml->goblinpoint_config_id = $_POST['setting_6'];
	
	if(!Validator::UnsignedNumber($_POST['setting_7'])) throw new Exception('Submitted setting is not valid (ruud_config_id)');
	$xml->ruud_config_id = $_POST['setting_7'];
	
	// reward type
	foreach($_POST['setting_8'] as $k => $setting8) {
		if(!in_array($setting8, $rewardTypeList)) throw new Exception('Submitted setting is not valid (reward type #'.($k+1).')');
		$xml->rewards->reward[$k]->type = $setting8;
	}
	
	// reward name
	foreach($_POST['setting_9'] as $k => $setting9) {
		if(!check_value($setting9)) throw new Exception('Submitted setting is not valid (reward name #'.($k+1).')');
		$xml->rewards->reward[$k]->name = $setting9;
	}
	
	// reward short name
	foreach($_POST['setting_10'] as $k => $setting10) {
		if(!check_value($setting10)) throw new Exception('Submitted setting is not valid (reward short name #'.($k+1).')');
		$xml->rewards->reward[$k]->shortname = $setting10;
	}
	
	// reward amount
	foreach($_POST['setting_11'] as $k => $setting11) {
		if(!Validator::UnsignedNumber($setting11)) throw new Exception('Submitted setting is not valid (reward amount #'.($k+1).')');
		$xml->rewards->reward[$k]->amount = $setting11;
	}
	
	// reward chance
	$chanceSum = 0;
	foreach($_POST['setting_12'] as $k => $setting12) {
		if(!Validator::UnsignedNumber($setting12)) throw new Exception('Submitted setting is not valid (reward chance #'.($k+1).')');
		$xml->rewards->reward[$k]->chance = $setting12;
		$chanceSum += $setting12;
	}
	
	// change sum check
	if($chanceSum > 100) throw new Exception('The sum of all reward chance values cannot exceed 100!');

	$save = @$xml->asXML($xmlPath);
	if(!$save) throw new Exception('There has been an error while saving changes.');
}

if(check_value($_POST['submit_changes'])) {
	try {
		saveChanges($rewardTypeList);
		message('success', 'Settings successfully saved.');
	} catch (Exception $ex) {
		message('error', $ex->getMessage());
	}
}

if(check_value($_GET['checkusercplinks'])) {
	try {
		$MuRoulette = new \Plugin\MuRoulette\MuRoulette();
		$MuRoulette->checkPluginUsercpLinks();
		message('success', 'UserCP Links Successfully Added!');
	} catch (Exception $ex) {
		message('error', $ex->getMessage());
	}
}

// load configs
$pluginConfig = simplexml_load_file(__PATH_ROULETTE_ROOT__.'config.xml');
if(!$pluginConfig) throw new Exception('Error loading config file.');

// credit system
$creditSystem = new CreditSystem();
?>
<h2>Mu Roulette Settings</h2>
<form action="" method="post">
	
	<h4>Ticket Settings</h4>
	<table class="table table-striped table-bordered table-hover module_config_tables">
        <tr>
            <th>Ticket Cost<br/><span>Cost of the ticket to spin the roulette.</span></th>
            <td>
				<input class="form-control" type="text" name="setting_1" value="<?php echo $pluginConfig->spin_ticket_cost; ?>"/>
            </td>
        </tr>
		<tr>
			<th>Ticket Cost Credit Configuration<br/><span>Type of credits required to purchase a roulette ticket</span></th>
			<td>
				<?php echo $creditSystem->buildSelectInput("setting_2", $pluginConfig->spin_ticket_configid, "form-control"); ?>
			</td>
		</tr>
	</table>
	
	<h4>Credit configuration Settings</h4>
	<table class="table table-striped table-bordered table-hover module_config_tables">
		<tr>
			<th>WCoin Credit Configuration<br/><span></span></th>
			<td>
				<?php echo $creditSystem->buildSelectInput("setting_3", $pluginConfig->wcoin_config_id, "form-control"); ?>
			</td>
		</tr>
		<tr>
			<th>WcoinC Credit Configuration<br/><span></span></th>
			<td>
				<?php echo $creditSystem->buildSelectInput("setting_4", $pluginConfig->wcoinc_config_id, "form-control"); ?>
			</td>
		</tr>
		<tr>
			<th>WcoinP Credit Configuration<br/><span></span></th>
			<td>
				<?php echo $creditSystem->buildSelectInput("setting_5", $pluginConfig->wcoinp_config_id, "form-control"); ?>
			</td>
		</tr>
		<tr>
			<th>Goblin Points Credit Configuration<br/><span></span></th>
			<td>
				<?php echo $creditSystem->buildSelectInput("setting_6", $pluginConfig->goblinpoint_config_id, "form-control"); ?>
			</td>
		</tr>
		<tr>
			<th>Ruud Credit Configuration<br/><span></span></th>
			<td>
				<?php echo $creditSystem->buildSelectInput("setting_7", $pluginConfig->ruud_config_id, "form-control"); ?>
			</td>
		</tr>
    </table>
	
	<?php
	$i = 0;
	foreach($pluginConfig->rewards->children() as $reward) {
	?>
		<h4>Reward <?php echo ($i+1); ?></h4>
		<table class="table table-striped table-bordered table-hover module_config_tables">
			<tr>
				<th>Type<br/><span>Type of reward</span></th>
				<td>
					<select class="form-control" name="setting_8[]">
					<?php
					foreach($rewardTypeList as $rewardType) {
						if($rewardType == strtolower($reward->type)) {
							echo '<option value="'.$rewardType.'" selected>'.$rewardType.'</option>';
						} else {
							echo '<option value="'.$rewardType.'">'.$rewardType.'</option>';
						}
					}
					?>
					</select>
				</td>
			</tr>
			<tr>
				<th>Name<br/><span>Full name of the reward</span></th>
				<td>
					<input class="form-control" type="text" name="setting_9[]" value="<?php echo $reward->name; ?>"/>
				</td>
			</tr>
			<tr>
				<th>Short Name<br/><span>Short name of the reward (this will be displayed in the roulette)</span></th>
				<td>
					<input class="form-control" type="text" name="setting_10[]" value="<?php echo $reward->shortname; ?>"/>
				</td>
			</tr>
			<tr>
				<th>Amount<br/><span>Amount (quantity) of the reward to be given</span></th>
				<td>
					<input class="form-control" type="text" name="setting_11[]" value="<?php echo $reward->amount; ?>"/>
				</td>
			</tr>
			<tr>
				<th>Chance %<br/><span>Chance percentage of receiving reward (the sum of all reward chances must be equal to 100)</span></th>
				<td>
					<input class="form-control" type="text" name="setting_12[]" value="<?php echo $reward->chance; ?>"/>
				</td>
			</tr>
		</table>
	<?php
		$i++;
	}
	?>
	
	<table class="table table-striped table-bordered table-hover module_config_tables">
		<tr>
            <td colspan="2"><input type="submit" name="submit_changes" value="Save Changes" class="btn btn-success"/></td>
        </tr>
    </table>
</form>

<hr>

<h2>UserCP Links</h2>
<p>Click the button below to automatically add the plugin's links to the user control panel menu.</p>
<a href="<?php echo admincp_base('roulette&page=settings&checkusercplinks=1'); ?>" class="btn btn-primary">Add UserCP Links</a>